/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.snmp;

import com.ibm.hwmca.api.SNMPTrap;
import com.ibm.hwmca.api.SNMPTrapSender;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.snmp.SnmpConstants;
import com.ibm.hwmca.fw.snmp.SnmpErrorIds;
import com.ibm.hwmca.fw.snmp.SnmpTrap;
import com.ibm.hwmca.fw.snmp.SnmpTrapListener;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;

public class SnmpTrapSender
implements SnmpConstants,
SnmpErrorIds {
    protected ArrayList trapListeners = new ArrayList();
    protected static DatagramSocket socket;
    protected String defaultCommunity = "public";
    protected static final long initTime;
    protected static final String SNMP_TRAPS_FILE = "snmp.traps.properties";
    protected static final int SNMP_TRAP_PORT = 162;
    protected static final String TRACE_MASKD = "XSNMPTSD";
    protected static final String TRACE_MASKT = "XSNMPTST";
    protected static final String TRACE_MASKF = "XSNMPTSF";

    public void setDefaultCommunity(String community) {
        this.defaultCommunity = community;
    }

    public void addTrapListener(SnmpTrapListener listener) {
        this.trapListeners.add(listener);
    }

    public static void sendTrap(SnmpTrap trap, String addr, String community) throws IOException {
        Trace.trace(TRACE_MASKT, "-> SnmpTrapSender.sendTrap(trap, " + addr + ", " + community + ")");
        InetAddress inetAddr = InetAddress.getByName(addr);
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, community);
        DatagramPacket packet = new DatagramPacket(buf, buf.length, inetAddr, 162);
        socket.send(packet);
        Trace.trace(TRACE_MASKT, "<- SnmpTrapSender.sendTrap(trap, " + addr + ", " + community + ")");
    }

    public void sendTrap(SnmpTrap trap) throws IOException {
        Trace.trace(TRACE_MASKT, "-> SnmpTrapSender.sendTrap");
        byte[] buf = SNMPTrapSender.buildTrapPacket(trap, this.defaultCommunity);
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        ListIterator it = this.trapListeners.listIterator();
        while (it.hasNext()) {
            SnmpTrapListener listener = (SnmpTrapListener)it.next();
            Trace.trace(TRACE_MASKD, "listener was registered.. attempting to send trap");
            packet.setAddress(listener.getAddress());
            packet.setPort(listener.getPort());
            socket.send(packet);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTrapSender.sendTrap");
    }

    public void sendTraps(List traps) throws IOException {
        Trace.trace(TRACE_MASKT, "-> SnmpTrapSender.sendTraps");
        ListIterator it = traps.listIterator();
        while (it.hasNext()) {
            SnmpTrap trap = (SnmpTrap)it.next();
            this.sendTrap(trap);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTrapSender.sendTraps");
    }

    public static byte[] buildTrapPacket(SnmpTrap trap, String community) {
        return SNMPTrapSender.buildTrapPacket(trap, community);
    }

    public static void sendTrapToConfiguredHosts(SnmpTrap trap, String key, String community) throws IOException {
        File snmpTrapsFile;
        Trace.trace(TRACE_MASKT, "-> SnmpTrapSender.sendTrapToConfiguredHosts([" + trap + "], " + key + ", " + community + ")");
        try {
            snmpTrapsFile = new File(BaseFileControl.getFilePath(SNMP_TRAPS_FILE) + SNMP_TRAPS_FILE);
        }
        catch (HException hexc) {
            Trace.trace(TRACE_MASKF, hexc);
            throw new IOException("BaseFileControl.getFilePath(snmp.traps.properties) failed.");
        }
        if (snmpTrapsFile.exists() && snmpTrapsFile.canRead()) {
            Trace.trace(TRACE_MASKF, "SnmpTrapSender.sendTrapToConfiguredHosts: loading traps properties file.");
            FileInputStream fis = new FileInputStream(snmpTrapsFile);
            Properties props = new Properties();
            props.load(fis);
            ArrayList<Object> hosts = new ArrayList<Object>();
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String keyList = (String)entry.getValue();
                if (!keyList.matches(".*" + key + ".*")) continue;
                Trace.trace(TRACE_MASKF, "SnmpTrapSender.sendTrapToConfiguredHosts: found matching key.. adding: " + entry.getKey());
                hosts.add(entry.getKey());
            }
            if (!hosts.isEmpty()) {
                it = hosts.iterator();
                while (it.hasNext()) {
                    String addr = (String)((Object)it.next());
                    SnmpTrapSender.sendTrap(trap, addr, community);
                }
            } else {
                Trace.trace(TRACE_MASKF, "SnmpTrapSender.sendTrapToConfiguredHosts: no hosts configured to receive this trap.");
            }
        } else {
            Trace.trace(TRACE_MASKF, "SnmpTrapSender.sendTrapToConfiguredHosts: Unable to read traps file.");
            throw new IOException("Unable to read trap configuration file.");
        }
        Trace.trace(TRACE_MASKT, "<- SnmpTrapSender.sendTrapToConfiguredHosts");
    }

    public static void main(String[] args) throws IOException {
        SnmpTrap trap = new SnmpTrap("1.3.6.1.4.1.2.6.42", 16);
        trap.addVarBind(new SNMPTrap.VarBind("1.3.6.1.4.1.2.6.42.1", "hello"));
        SnmpTrapSender.sendTrapToConfiguredHosts(trap, "com.ibm.hwmca.z.snmp.SnmpTrap6", "public");
    }

    static {
        initTime = System.currentTimeMillis();
        try {
            socket = new DatagramSocket();
        }
        catch (SocketException e) {
            Trace.trace(TRACE_MASKF, e);
        }
    }
}

